#include <iostream>
#include <vector>
#include <queue>
using namespace std;

const int kMaxT = 3600;

const int INF = 1e9;

int main()
{
    ios_base::sync_with_stdio(false);

    int tests;
    cin >> tests;
    for (int test = 0; test < tests; ++test) {
        int n, t;
        vector<int> b;

        cin >> n >> t;
        b.resize(n);
        for (int i = 0; i < n; ++i) {
            cin >> b[i];
        }

        vector<int> a(kMaxT + 1, INF);

        a[0] = 0;

        priority_queue<pair<int, int>, vector<pair<int, int> >, greater<pair<int, int> > > q;

        q.push(make_pair(0, 0));

        while (!q.empty()) {
            int v = q.top().second;
            int len = q.top().first;

            q.pop();

            if (a[v] < len) {
                continue;
            }

            for (int i = 0; i < n; ++i) {
                int val = v + b[i];
                if (val >= kMaxT) {
                    val = kMaxT;
                }
                if (val < 0) {
                    val = 0;
                }

                if (a[v] + 1 < a[val]) {
                    a[val] = a[v] + 1;
                    q.push(make_pair(a[val], val));
                }
            }
        }

        for (int cur_t = t; cur_t <= kMaxT; ++cur_t) {
            if (a[cur_t] < INF) {
                cout << a[cur_t] << " " << cur_t - t << endl;
                break;
            }
        }
    }

    return 0;
}
